/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.harvest;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.json.predicate.IJsonPredicate;
import slimeknights.tconstruct.library.json.predicate.block.BlockPredicate;
import slimeknights.tconstruct.library.json.predicate.block.SetBlockPredicate;
import slimeknights.tconstruct.library.json.predicate.block.TagBlockPredicate;
import slimeknights.tconstruct.library.tools.definition.harvest.IHarvestLogic;
import slimeknights.tconstruct.library.tools.definition.harvest.TagHarvestLogic;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class ModifiedHarvestLogic
extends TagHarvestLogic {
    public static final Loader LOADER = new Loader();
    private final SpeedModifier[] speedModifiers;

    protected ModifiedHarvestLogic(class_6862<class_2248> tag, SpeedModifier[] speedModifiers) {
        super(tag);
        this.speedModifiers = speedModifiers;
    }

    public static Builder builder(class_6862<class_2248> tag) {
        return new Builder(tag);
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<? extends IHarvestLogic> getLoader() {
        return LOADER;
    }

    @Override
    public float getDestroySpeed(IToolStackView tool, class_2680 state) {
        float speed = super.getDestroySpeed(tool, state);
        for (SpeedModifier modifier : this.speedModifiers) {
            if (!modifier.predicate.matches(state)) continue;
            return Math.max(1.0f, speed * modifier.modifier);
        }
        return speed;
    }

    private static class SpeedModifier {
        protected final float modifier;
        protected final IJsonPredicate<class_2680> predicate;

        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("modifier", (Number)Float.valueOf(this.modifier));
            json.add("predicate", BlockPredicate.LOADER.serialize(this.predicate));
            return json;
        }

        public void toNetwork(class_2540 buffer) {
            buffer.writeFloat(this.modifier);
            BlockPredicate.LOADER.toNetwork(this.predicate, buffer);
        }

        private static SpeedModifier fromJson(JsonObject json) {
            float modifier = class_3518.method_15259((JsonObject)json, (String)"modifier");
            IJsonPredicate<class_2680> predicate = BlockPredicate.LOADER.deserialize((JsonElement)class_3518.method_15296((JsonObject)json, (String)"predicate"));
            return new SpeedModifier(modifier, predicate);
        }

        private static SpeedModifier fromNetwork(class_2540 buffer) {
            float modifier = buffer.readFloat();
            IJsonPredicate<class_2680> predicate = BlockPredicate.LOADER.fromNetwork(buffer);
            return new SpeedModifier(modifier, predicate);
        }

        public SpeedModifier(float modifier, IJsonPredicate<class_2680> predicate) {
            this.modifier = modifier;
            this.predicate = predicate;
        }
    }

    public static class Builder {
        private final class_6862<class_2248> tag;
        private final List<SpeedModifier> speedModifiers = new ArrayList<SpeedModifier>();

        public Builder addModifier(float modifier, IJsonPredicate<class_2680> predicate) {
            this.speedModifiers.add(new SpeedModifier(modifier, predicate));
            return this;
        }

        public Builder tagModifier(class_6862<class_2248> tag, float modifier) {
            return this.addModifier(modifier, new TagBlockPredicate(tag));
        }

        public Builder notTagModifier(class_6862<class_2248> tag, float modifier) {
            return this.addModifier(modifier, new TagBlockPredicate(tag).inverted());
        }

        public Builder blockModifier(float modifier, class_2248 ... blocks) {
            return this.addModifier(modifier, new SetBlockPredicate((Set<class_2248>)ImmutableSet.copyOf((Object[])blocks)));
        }

        public Builder notBlockModifier(float modifier, class_2248 ... blocks) {
            return this.addModifier(modifier, new SetBlockPredicate((Set<class_2248>)ImmutableSet.copyOf((Object[])blocks)).inverted());
        }

        public ModifiedHarvestLogic build() {
            return new ModifiedHarvestLogic(this.tag, this.speedModifiers.toArray(new SpeedModifier[0]));
        }

        protected Builder(class_6862<class_2248> tag) {
            this.tag = tag;
        }
    }

    private static class Loader
    implements GenericLoaderRegistry.IGenericLoader<ModifiedHarvestLogic> {
        private Loader() {
        }

        @Override
        public ModifiedHarvestLogic deserialize(JsonObject json) {
            class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)JsonHelper.getResourceLocation(json, "effective"));
            SpeedModifier[] modifiers = JsonHelper.parseList(json, "modifiers", SpeedModifier::fromJson).toArray(new SpeedModifier[0]);
            return new ModifiedHarvestLogic((class_6862<class_2248>)tag, modifiers);
        }

        @Override
        public ModifiedHarvestLogic fromNetwork(class_2540 buffer) {
            class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)buffer.method_10810());
            SpeedModifier[] modifiers = new SpeedModifier[buffer.method_10816()];
            for (int i = 0; i < modifiers.length; ++i) {
                modifiers[i] = SpeedModifier.fromNetwork(buffer);
            }
            return new ModifiedHarvestLogic((class_6862<class_2248>)tag, modifiers);
        }

        @Override
        public void serialize(ModifiedHarvestLogic object, JsonObject json) {
            json.addProperty("effective", object.tag.comp_327().toString());
            JsonArray modifiers = new JsonArray();
            for (SpeedModifier modifier : object.speedModifiers) {
                modifiers.add((JsonElement)modifier.toJson());
            }
            json.add("modifiers", (JsonElement)modifiers);
        }

        @Override
        public void toNetwork(ModifiedHarvestLogic object, class_2540 buffer) {
            buffer.method_10812(object.tag.comp_327());
            buffer.method_10804(object.speedModifiers.length);
            for (SpeedModifier modifier : object.speedModifiers) {
                modifier.toNetwork(buffer);
            }
        }
    }
}

